<script src="<?=ROOT_URL?>/src/main.min.js" ></script>
<link rel="stylesheet" href="<?=ROOT_URL?>/src/style.css?v=5.0.3">

<div class="col-12 col-md-4 text-center mb-5">
<div class="card">
<div class="card-header">Current Signature <small>(Required for reporting)</small></div>
<div class="card-body">
<div class="col-md-8 offset-md-2">
<div id="slimBox" class="slim" data-ratio="16:7" data-did-remove="imageRemoved" data-label="Signature File" data-force-type="jpg" data-service="images/signature_save.php" data-filter-sharpen="20" data-push="true" data-meta-userid="<?= $cd['id']?>" data-meta-imageid="logo" data-size="330,152">
<?php if(file_exists('images/signatures/'.$cd['id'].'.jpg')){?>
<img src="images/signatures/<?= $cd['id']?>.jpg?<?= rand()?>" alt="Avatar">
<?php }?>
<input type="file" name="file"/>
</div>
</div>
</div>
</div>
</div>
<style>
.fullscreen-card {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  z-index: 9999;
}</style>

<div class="col-12 col-md-4 text-center mb-5">
<div id="sigCard" class="card">
<div class="card-header">Create Signature <i class="fad fa-hand-point-up"></i> <span class="float-end"><a id="sigHead" class="text-light" href="javascript:void(0)" onclick="expanSig()"><i class="fad fa-expand"></i> Open</a></span></div>
<div class="card-body">
    <div class="row">
        <div id="sigBlock" class="col-12 text-center hidden">
        <p class="muted">Make sure your signature is within the boundary, if you are unhappy with the attempt, use the clear button and retry.</p>
          <div class="js-signature" data-width="660" data-height="250" data-border="1px dashed #333333" data-background="#ffffff" data-line-color="#000000" data-auto-fit="false"></div>
          <p><a id="clearBtn" class="btn btn-info" onclick="clearCanvas();">Clear</a>&nbsp;<a id="saveBtn2" class="btn btn-default" onclick="saveSignature();" disabled>Save Signature</a></p>
          <div id="signature"></div>
        </div>
      </div> 
</div>
</div>
</div>

<script src="<?=ROOT_URL?>/src/js/jq-signature.js" ></script>
<script>
// Function to toggle signature expansion
function expanSig() {
  const card = document.getElementById('sigCard');
  const sig = document.getElementById('sigBlock');
  const exButton = document.getElementById('sigHead');

  // Toggle fullscreen mode and visibility
  if (card.classList.contains('fullscreen-card')) {
    card.classList.remove('fullscreen-card');
    sig.classList.add('hidden');
    exButton.innerHTML = '<i class="fad fa-expand"></i> Open';
  } else {
    card.classList.add('fullscreen-card');
    sig.classList.remove('hidden');
    exButton.innerHTML = '<i class="fad fa-compress"></i> Close';
  }
}

// Initialize jqSignature using jQuery
$(".js-signature").jqSignature({
  background: '#ffffff'
});

// Function to clear signature canvas
function clearCanvas() {
  const signatureContainer = document.getElementById('signature');
  signatureContainer.innerHTML = "";
  $(".js-signature").jqSignature("clearCanvas");
  document.getElementById('saveBtn').disabled = true; // Disable save button after clearing
}

// Function to save the signature
function saveSignature() {
  const signatureContainer = document.getElementById('signature');
  signatureContainer.innerHTML = ""; // Clear signature container

  // Get the signature as a data URL using jqSignature (requires jQuery)
  const dataUrl = $(".js-signature").jqSignature("getDataURL");

  // Create new FormData to send the image data
  const formData = new FormData();
  formData.append('imageData', dataUrl);
  formData.append('userid', "<?= $cd['id'] ?>");

  // AJAX request to save the signature using pure JavaScript
  const xhr = new XMLHttpRequest();
  xhr.open("POST", "images/signature_save2.php", true);
  xhr.onload = function() {
    if (xhr.status === 200) {
      const cropper = new Slim(document.getElementById('slimBox'));
      cropper.load('images/signatures/<?=$cd['id']?>.jpg', function(error, data) {
        if (!error) {
          console.log('Image loaded successfully');
        }
      });
      expanSig(); // Collapse signature view after save
    } else {
      console.error("Error saving signature: " + xhr.statusText);
    }
  };
  xhr.onerror = function() {
    console.error("Network Error: Could not complete the request.");
  };
  xhr.send(formData);
}

// Event listener for signature change (replacing jQuery event binding)
document.querySelector(".js-signature").addEventListener("jq.signature.changed", function () {
  document.getElementById("saveBtn").disabled = false; // Enable save button when signature is updated
});

    </script>