<!--- CONTRACT ####################################################################################################### -->
<div class="col-12 col-md-4 mt-5">
    <div class="card">
        <div class="card-header bg-primary text-white">Contract Details</div>
        <div class="card-body">
            <div class="mb-3 form-check">
                <?php $checked = (safeValue($cd, 'contractMode') == "1") ? "checked" : ""; ?>
                <input type="checkbox" class="form-check-input" <?= $checked ?> name="contractMode" id="contractMode">
                <label class="form-check-label" for="contractMode">Annual Contract</label>
            </div>

            <div id="contractOptions">
                <div class="mb-3">
                    <label class="form-label" for="rate_per_hour">Contract Fee</label>
                    <input class="form-control" type="number" step="0.01" name="rate_per_hour" id="rate_per_hour" value="<?= safeValue($cd, 'rate_per_hour') ?>" />
                </div>

                <div class="mb-3">
                    
                    <div class="col-12 col-md-6 date-picker" data-date-type="past" data-mdb-toggle-button="false" data-format="dd-mm-yyyy">
                    <label class="form-label" for="incepton_date">Inception Date</label>
                    <input class="form-control" data-mdb-confirmDateOnSelect data-mdb-toggle="datepicker" type="text" name="incepton_date" id="incepton_date" value="<?= safeValue($cd, 'incepton_date', date('d-m-Y'),true) ?>" />                    
                </div>

                <div class="mb-3">
                    <label class="form-label" for="term_years">Term Years</label>
                    <select class="form-select" name="term_years" id="term_years">
                        <option value="0.5" <?php if (safeValue($cd, 'term_years') == '0.5') { ?> selected <?php } ?>>0.5</option>
                        <?php foreach (range(1, 10) as $n) { ?>
                            <option value="<?= $n ?>" <?php if (safeValue($cd, 'term_years') == $n) { ?> selected <?php } ?>><?= $n ?></option>
                        <?php } ?>
                    </select>
                </div>

               <div class="mb-3">
                    
                    <div class="col-12 col-md-6 date-picker" data-date-type="future" data-mdb-toggle-button="false" data-format="dd-mm-yyyy">
                    <label class="form-label" for="incepton_date">Renewal Date</label>
                    <input class="form-control" data-mdb-confirmDateOnSelect data-mdb-toggle="datepicker" type="text" name="renewal_date" id="renewal_date" value="<?= safeValue($cd, 'renewal_date', date('d-m-Y'),true) ?>" />                    
                </div>

                <div class="mb-3">
                    <label class="form-label" for="renewal_status">Renewal Status</label>
                    <select class="form-select autocomplete" name="renewal_status" id="renewal_status">
                        <option value="">NONE</option>
                        <option value="ACTIVE" <?php if (safeValue($cd, 'renewal_status') === "ACTIVE") { ?> selected <?php } ?>>ACTIVE</option>
                        <option value="OVERDUE" <?php if (safeValue($cd, 'renewal_status') === "OVERDUE") { ?> selected <?php } ?>>OVERDUE</option>
                        <option value="LAPSED" <?php if (safeValue($cd, 'renewal_status') === "LAPSED") { ?> selected <?php } ?>>LAPSED</option>
                    </select>
                </div>


                <div class="row mb-3">
                    <div class="col-12 col-md-6">
                        <div class="col-12 label">Set recipient of renewal notices:</div>
                        <div class="col-12 p-2">
                            <div class="d-flex justify-content-between">
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" id="r1" name="A1" value="0" <?php if (safeValue($rdata, 'notice') == 0) { ?> checked <?php } ?>>
                                    <label class="form-check-label" for="r1">Client</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" id="r2" name="A1" value="1" <?php if (safeValue($rdata, 'notice') == 1) { ?> checked <?php } ?>>
                                    <label class="form-check-label" for="r2">Agent</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" id="r3" name="A1" value="2" <?php if (safeValue($rdata, 'notice') == 2) { ?> checked <?php } ?>>
                                    <label class="form-check-label" for="r3">Broker</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-6">
                        <div class="col-12 label">Set recipient of invoice and notices:</div>
                        <div class="col-12 p-2">
                            <div class="d-flex justify-content-between">
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" id="r1i" name="A1i" value="0" <?php if (safeValue($rdata, 'inotice') == 0) { ?> checked <?php } ?>>
                                    <label class="form-check-label" for="r1i">Client</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" id="r2i" name="A1i" value="1" <?php if (safeValue($rdata, 'inotice') == 1) { ?> checked <?php } ?>>
                                    <label class="form-check-label" for="r2i">Agent</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" id="r3i" name="A1i" value="2" <?php if (safeValue($rdata, 'inotice') == 2) { ?> checked <?php } ?>>
                                    <label class="form-check-label" for="r3i">Broker</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                </div></div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3 form-check">
                            <?php $checked = (safeValue($cd, 'autoRenew') == "1") ? "checked" : ""; ?>
                            <input type="checkbox" class="form-check-input" <?= $checked ?> name="autoRenew" id="autoRenew">
                            <label class="form-check-label" for="autoRenew">Auto Renew</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="col-12 col-md-6 col-xl-4 mt-5">
    <div class="card">
        <div class="card-header">Account Information</div>
        <div class="card-body">
            <div class="mb-3">
                <label class="form-label" for="agent_number">Agent</label>
                <div><?= listAgent(safeValue($cd, 'agent_number'), 'agent_number', 'select', '') ?></div>
            </div>
            <div class="mb-3">
                <label class="form-label" for="broker_number">Broker</label>
                <div><?= listBroker(safeValue($cd, 'broker_number'), 'broker_number', 'select', '') ?></div>
            </div>
            <div class="mb-3">
                <label class="form-label" for="account_handler">Account Handler</label>
                <input class="form-control" type="text" name="account_handler" id="account_handler" value="<?= safeValue($cd, 'account_handler') ?>" />
            </div>

            <div class="row mb-3">
                <div class="col-6">
                    <label class="form-label" for="commission">Commission</label>
                    <input class="form-control" type="text" name="commission" id="commission" value="<?php if(empty(safeValue($cd, 'commission'))){echo "0";}else{echo safeValue($cd, 'commission');} ?>" />
                </div>
                <div class="col-3">
                    <div class="form-check">
                        <input type="radio" class="form-check-input" name="comType" id="comTypePercent" value="0" <?= $cd['comType'] == 0 || $isNewMode ? 'checked' : '' ?>>
                        <label class="form-check-label" for="comTypePercent">Percent</label>
                    </div>
                </div>
                <div class="col-3">
                    <div class="form-check">
                        <input type="radio" class="form-check-input" name="comType" id="comTypeFixed" value="1" <?= $cd['comType'] == 1 ? 'checked' : '' ?>>
                        <label class="form-check-label" for="comTypeFixed">Fixed</label>
                    </div>
                </div>
            </div>

            <?php if ($cd['agent_number'] != 0) : ?>
                <div class="row">
                    <div class="col-12 text-end">
                        <a class="btn btn-secondary btn-sm m-0 px-3 waves-effect waves-light noprint" href="?t=includes/master&p=agent.php&agent_number=<?= safeValue($cd, 'agent_number') ?>&view=edit"><i class="fad fa-pencil"></i> Edit Agent / Broker</a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
   const agentNumberElement = document.getElementById('agent_number')
const brokerNumberElement = document.getElementById('broker_number')

// Event listener for the agent select
    agentNumberElement.addEventListener('change', function () {
        if (this.value !== "0") { //alert('agent')
            brokerNumberElement.value = 0;
        }
    });
    // Event listener for the broker select
    brokerNumberElement.addEventListener('change', function () {
        if (this.value !== "0") {//alert('broker')
            agentNumberElement.value = 0; 
        }
    });
});


document.addEventListener('DOMContentLoaded', function() {
    const contractModeCheckbox = document.getElementById('contractMode');
    const ratePerHourInput = document.getElementById('rate_per_hour');
    const renewalDateInput = document.getElementById('renewal_date');
    const renewalStatusInput = document.getElementById('renewal_status');
    const autoRenewCheckbox = document.getElementById('autoRenew');
    const renewOptions = document.getElementById('renewOptions');

    // Check if renewOptions exists before attempting to use it
    if (renewOptions) {
        renewOptions.style.display = autoRenewCheckbox.checked ? 'block' : 'none';

        autoRenewCheckbox.addEventListener('change', function() {
            renewOptions.style.display = this.checked ? 'block' : 'none';
        });
    }

    // Initialize disabled states based on contractModeCheckbox
    if (!contractModeCheckbox.checked) {
        ratePerHourInput.disabled = true;
        renewalDateInput.disabled = true;
        renewalStatusInput.disabled = true;
        autoRenewCheckbox.disabled = true;
    }

    // Add event listener for contractModeCheckbox change
    contractModeCheckbox.addEventListener('change', function() {
        const isChecked = this.checked;
        ratePerHourInput.disabled = !isChecked;
        renewalDateInput.disabled = !isChecked;
        renewalStatusInput.disabled = !isChecked;
        autoRenewCheckbox.disabled = !isChecked;
    });

    // Set up event listeners for radio buttons to sync related elements
    const radioButtons = {
        r1: document.getElementById('r1'),
        r1i: document.getElementById('r1i'),
        r2: document.getElementById('r2'),
        r2i: document.getElementById('r2i'),
        r3: document.getElementById('r3'),
        r3i: document.getElementById('r3i'),
    };

    // Ensure radio buttons are found before setting up event listeners
    if (radioButtons.r1 && radioButtons.r1i) {
        radioButtons.r1.addEventListener('change', function() {
            if (this.checked) {
                radioButtons.r1i.checked = true;
                document.getElementById('broker_number').value = '0';
                document.getElementById('agent_number').value = '0';
                document.getElementById('commission').value = '';
            }
        });
    }

    if (radioButtons.r2 && radioButtons.r2i) {
        radioButtons.r2.addEventListener('change', function() {
            if (this.checked) {
                document.getElementById('broker_number').value = '0';
                radioButtons.r2i.checked = true;
            }
            document.getElementById('commission').value = '';
        });
    }

    if (radioButtons.r3 && radioButtons.r3i) {
        radioButtons.r3.addEventListener('change', function() {
            if (this.checked) {
                document.getElementById('agent_number').value = '0';
                radioButtons.r3i.checked = true;
            }
        });
    }
});

</script>