<!--- ACCESS ####################################################################################################### -->
<?php

?>
<div class="col-12 col-md-8 mt-5">
    <div class="card">
        <div class="card-header">
            Client Access
            <span class="float-end">
                <button type="button" class="btn btn-sm btn-secondary m-0 px-3 py-2" onclick="newUser()">
                    <i class="fad fa-plus"></i>
                </button>
            </span>
        </div>
        <div class="card-body">
            <div id="newRow" class="col-12 d-none">
                <div class="row mb-4 bg-light">
                    <div class="col-12">
                        <p class="lead">New User</p>
                    </div>
                    <div class="col-3">
                        <input type="text" name="name" class="form-control form-control-sm" placeholder="Name">
                    </div>
                    <div class="col-3"><?= getSites($_REQUEST['clientnumber'], 'select') ?></div>
                    <div class="col-3">
                        <input type="text" name="username" class="form-control form-control-sm" placeholder="Email">
                    </div>
                    <div class="col-3">
                        <input type="text" name="password" class="form-control form-control-sm" placeholder="Password" autocomplete="new-password" />
                    </div>
                    <div class="col-12 text-center mt-4">
                        <button type="button" class="btn btn-info btn-sm me-4" onclick="saveNew()">Create</button>
                        <button type="button" class="btn btn-secondary btn-sm" onclick="cancelNew()">Cancel</button>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-12">
                <div class="table-responsive">
                    <table id="userTable" class="table table-bordered table-sm table-striped">
                        <thead class="table-dark">
                            <tr>
                                <th>Name</th>
                                <th>Access</th>
                                <th>Email</th>
                                <th>Password</th>
                                <th width="190"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $stmt = $GLOBALS['con']->prepare("SELECT *, AES_DECRYPT(password, username) AS pass FROM `client_users` WHERE `clientnumber`=?") or die($error = mysqli_error($GLOBALS['con']));
                            $stmt->bind_param('i', $_REQUEST['clientnumber']);
                            $stmt->execute();
                            $res = $stmt->get_result();
                            $stmt->close();
                            while ($userData = mysqli_fetch_array($res)) {
                                 $email_values = [
    0 => '0', // client
    1 => $userData['name'], 
    2 => $userData['username'],
    3 => getCompanyDetails('name') . ' login Details',
    4 => 'Your login details for access to your reports are as follows:' . PHP_EOL .
         'URL: ' . htmlspecialchars('<a href="' . getCompanyDetails('web') . '/client">LINK</a>') . "\n" .
         'Username: ' . $userData['username'] . "\n" .
         'Password: ' . $userData['pass'], 
    5 => '', 
    6 => '',
];

// Ensure consistent formatting and prevent JSON escaping issues
$email64_values = base64_encode(json_encode($email_values, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));
?>

                            <tr id="R<?= safeValue($userData, 'id') ?>">
                                <td>
                                    <input name="name" class="form-control form-control-sm" value="<?= safeValue($userData, 'name') ?>">
                                </td>
                                <td><?= getSites($_REQUEST['clientnumber'], $userData['access']) ?></td>
                                <td>
                                    <input name="username" class="form-control form-control-sm" value="<?= safeValue($userData, 'username') ?>">
                                </td>
                                <td>
                                    <input class="form-control form-control-sm" type="text" name="password" value="<?= safeValue($userData, 'pass') ?>" autocomplete="new-password" required />
                                </td>
                                <td class="text-end">
                                    <button type="button" class="btn btn-success btn-sm m-0" onclick="saveChange('<?= safeValue($userData, 'id') ?>')">
                                        <i class="fad fa-save"></i>
                                    </button>
                                    <button type="button" class="btn btn-danger btn-sm m-0" onclick="deleteUser('<?= safeValue($userData, 'id') ?>')">
                                        <i class="fad fa-trash"></i>
                                    </button>
                                    <button type="button" class="btn btn-info btn-sm m-0 accessButton"
                                            data-values="<?= $email64_values ?>"
                                        
                                        data-mdb-tooltip-init 
                                        title="Email user login details"                                        
                                        data-mdb-placement="bottom"
                                        data-mdb-trigger="hover">
                                        <i class="fad fa-envelope"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>
</div>

<script>
function newUser() {
    const newRow = document.getElementById('newRow');
    newRow.classList.remove('d-none');
    newRow.classList.add('d-block');
}

function cancelNew() {
    const newRow = document.getElementById('newRow');
    const inputs = newRow.querySelectorAll('input');
    inputs.forEach(input => input.value = '');
    newRow.classList.add('d-none');
    newRow.classList.remove('d-block');
}

function saveNew() {
    const newRow = document.getElementById('newRow');
    const inputs = newRow.querySelectorAll('input:not(.ignore)');
    const values = {};

    inputs.forEach(input => {
        values[input.name] = input.value;
    });

    values['clientnumber'] = '<?= $_REQUEST['clientnumber'] ?>';
    const output = JSON.stringify(values);

    fetch(`${ROOT_URL}/includes/client/client_functions.php`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: new URLSearchParams({
            FUNCTION: 'saveClientUser',
            data: output,
            tenant: TENANT_URL
        })
    })
    .then(response => response.text())
    .then(ret => {
        const userTable = document.getElementById('userTable').querySelector('tbody');
        userTable.insertAdjacentHTML('beforeend', ret);

        
    });
}

document.querySelectorAll(".accessButton").forEach(button => {
            button.addEventListener('click', function(event) {
            const target = "<?= ROOT_URL ?>/includes/master/mailer.php";
            var string = event.target.dataset.values;
            var dest = encodeURI(target + "?data=" + string + "&mode=popup&tenant=" + TENANT_URL);
            loadModalContent(dest, "popupBox", "modal-xl", 1060, "true");
            });
        });


function saveChange(user) {
    const row = document.getElementById('R' + user);
    const elements = row.querySelectorAll('input:not(.ignore), select:not(.ignore)');
    const values = {};

    elements.forEach(element => {
        values[element.name] = element.value;
    });

    values['user'] = user;
    const output = JSON.stringify(values);

    fetch(`${ROOT_URL}/includes/client/client_functions.php`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: new URLSearchParams({
            FUNCTION: 'updateClientUser',
            data: output,
            tenant: TENANT_URL
        })
    })
    .then(response => response.text())
    .then(() => {
        showResponse('success','User client access updated successfully');
    });
}


function deleteUser(user) {
    fetch(`${ROOT_URL}/includes/client/client_functions.php`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: new URLSearchParams({
            FUNCTION: 'deleteClientUser',
            user: user,
            tenant: TENANT_URL
        })
    })
    .then(response => response.text())
    .then(() => {
        showResponse('success','User client access removed successfully');
        const row = document.getElementById('R' + user);
        if (row) {
            row.style.display = 'none';
        }
    });
}
</script>
